/*

TAREAS

-Añadir mas obstaculos/enemigos
-Añadir nuevas funciones para el personaje
-Arreglar errores (Colisiones, antorchas, enemigos, etc...)
-Añadir decoraciones

*/

//DATOS GENERALES
var canvas;
var ctx;
var FPS = 50;
var permitirQuitar = true;

var anchoF = 50;
var altoF = 50;

//PARA LA CÁMARA
/*
var anchoEscenario = 25;
var altoEscenario = 20;
*/

var anchoEscenario = 5;
var altoEscenario = 5;
/*

//COLORES
var muro = '#044f14';
var puerta = '#3a1700';
var tierra = '#c6892f';
var llave = '#c6bc00';

*/

//OBJETOS/PERSONAJES
var protagonista;
var enemigo=[];
var enemigo2=[];
var enemigo3=[];
var imagenAntorcha;

//VARIABLES tilemap
var tileMap;
var imgTilemap;

//EL ESCENARIO
var escenario = [
  [0,0,0,0,0,0],
  [0,2,2,0,0,0],
  [0,0,2,2,2,2],
  [0,0,2,0,0,2],
  [0,0,2,0,0,0],
  [0,0,2,0,0,0]
];

/*

NUMEROS TILES

0 = Muro
1 = Salida
2 = Suelo
3 = Llave Dorada
4 = Lava
5 = Candado Rojo
6 = Candado Azul
7 = Llave Azul
8 = Llave Roja
9 = Botas
10 = Mapa
11 = Puzzle
12 = Puzzle Difícil

*/

//NOTA: Los escenarios del bucle son distintos a los de aquí. Estos son los originales.

//[
  /*
  [0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0,  0,0,0,0,0,  0,0,0,0,0],
  [0,2,2,0,0, 0,2,2,2,2,  0,0,2,2,2,  2,2,2,2,2,  2,2,2,0,0],
  [0,0,2,2,2, 2,2,2,0,2,  0,0,2,2,0,  0,0,2,0,0,  2,0,0,0,0],
  [0,0,2,0,0, 2,2,2,0,2,  2,2,2,2,0,  0,0,0,0,0,  2,2,2,0,0],
  [0,0,2,2,2, 0,2,2,0,0,  2,2,2,0,0,  0,2,2,2,2,  2,0,2,0,0],

  [0,2,2,0,0, 0,0,2,0,0,  0,2,0,0,0,  0,2,0,0,2,  0,0,2,0,0],
  [0,0,2,0,0, 0,2,2,2,0,  0,2,2,2,0,  0,2,0,0,0,  0,0,2,0,0],
  [0,2,2,2,0, 0,2,0,0,2,  2,2,2,2,2,  2,2,0,0,2,  2,0,2,0,0],
  [0,2,2,3,0, 0,2,0,0,1,  2,2,2,2,0,  0,0,0,2,2,  2,2,2,0,0],
  [0,2,0,0,0, 0,0,0,0,0,  0,2,0,0,0,  0,0,0,0,0,  0,2,0,0,0],

  [0,2,2,2,0, 0,0,0,0,0,  0,2,0,0,0,  0,0,0,0,0,  0,2,0,0,0],
  [0,2,0,2,2, 2,0,0,0,0,  0,2,2,2,2,  0,0,0,0,0,  2,2,2,0,0],
  [0,2,0,2,2, 2,0,0,0,0,  0,2,0,0,2,  0,0,0,0,0,  2,2,2,0,0],
  [0,2,0,0,0, 2,0,0,0,0,  0,2,0,0,2,  0,0,0,0,0,  0,2,0,0,0],
  [0,2,0,0,0, 2,0,0,0,0,  0,2,0,0,2,  2,0,0,2,0,  0,2,0,0,0],

  [0,2,2,2,0, 2,0,0,0,0,  0,2,0,0,2,  2,0,0,2,0,  0,2,0,0,0],
  [0,2,0,2,0, 0,0,0,0,0,  0,2,0,0,2,  2,0,0,2,0,  0,2,0,0,0],
  [0,0,0,2,0, 0,0,0,0,0,  0,2,0,0,0,  2,2,2,2,0,  0,2,0,0,0],
  [0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0,  0,0,0,0,0,  0,0,0,0,0],
  [0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0,  0,0,0,0,0,  0,0,0,0,0]
];
*/

//----------------------------------------------
//PLANTILLA DE LA CAMARA
//ancho: anchura de la cámara
//alto: altura de la cámara
//tableroX: coordenadas x de la cámara
//tableroY: coordenadas y de la cámara
//pantallaX: coordenadasX dentro de la pantalla física
//pantallaY: coordenadasY dentro de la pantalla física


var camaraObj2 = function(ancho,alto,tableroX,tableroY,pantallaX,pantallaY){
  this.anchoCamara = ancho;
  this.altoCamara = alto;

  this.posX = tableroX;
  this.posY = tableroY;

  //Margenes en pixels, para hacer la animación fluida
  this.posXPixel = 0;
  this.posYPixel = 0;

  this.pantallaX = pantallaX;
  this.pantallaY = pantallaY;

  this.dibuja = function(){
    var textura;

    for(y=this.posY;y<(this.posY + this.altoCamara);y++){
      for(x=this.posX;x<(this.posX + this.anchoCamara);x++){
        textura = escenario[y][x];
        ctx.drawImage(imgTilemap,textura*32,0,32,32,(this.pantallaX + x - this.posX)*anchoF,(this.pantallaY + y - this.posY)*altoF,anchoF,altoF);
      }
    }

  this.arriba = function(){
     if(this.posY > 0){
      this.posY--;
    }
  }

  this.abajo = function(){
    if(this.posY < altoEscenario - this.altoCamara){
      this.posY++;
    }
  }

  this.derecha = function(){
    if(this.posX < anchoEscenario - this.anchoCamara){
      this.posX++;
    }
  }

  this.izquierda = function(){
    if(this.posX > 0){
      this.posX--;
    }
   }
  }
 }

//VARIABLES DE LAS CAMARAS
var camara;
var camara2;
var camara3;
var camara4;
var camara5;
var camara6;
var camara7;
var camara8;
var camara9;
var camara10;
var camara11;
var camara12;
var camara13;
var camara14;
var camara15;
var camara16;
var camara17;
var camara18;
var camara19;
var camara20;
var camara21;

function dibujaEscenario(){
  for(y=0;y<20;y++){
    for(x=0;x<25;x++){

      var tile = escenario[y][x];
      ctx.drawImage(tileMap,tile*32,0,32,32,anchoF*x,altoF*y,anchoF,altoF);
    }
  }
}

var antorcha = function(x,y){

//DATOS DE LA ANTORCHA
  this.x = x;
  this.y = y;

  this.retraso = 10;
  this.contador = 0;
  this.fotograma = 0; //0-3

 //CAMBIAMOS LOS FOTOGRAMAS DE LA ANTORCHA PARA HACER LA ANIMACION
  this.cambiaFotograma = function(){
    if(this.fotograma < 3) {
      this.fotograma++;
    }
    else{
      this.fotograma = 0;
    }

  }

 //DIBUJAMOS LAS ANTORCHA
  this.dibuja = function(){

    if(this.contador < this.retraso){
      this.contador++;
    }
    else{
      this.contador = 0;
      this.cambiaFotograma();
    }

    ctx.drawImage(tileMap,this.fotograma*32,64,32,32,anchoF*x,altoF*y,anchoF,altoF);
  }

}

//CLASE ENEMIGO
var malo = function(x,y){
    this.x = x;
    this.y = y;

  //DIRECCION DEL ENEMIGO (A DONDE VA IR)

    this.direccion = Math.floor(Math.random()*4);

    this.retraso = 50;
    this.fotograma = 0;

  //CARGAMOS LA IMAGEN DEL tilemap A LOS ENEMIGOS
    this.dibuja = function(){
      ctx.drawImage(tileMap,0,32,32,32,this.x*anchoF,this.y*altoF,anchoF,altoF);
    }

   //EL ENEMIGO COMPRUEBA LA COLISION
    this.compruebaColision = function(x,y){
        var colisiona = false;

        if(escenario[y][x]==0){
          colisiona = true;
        }
        return colisiona;
    }

   //LOS ENEMIGOS SE MUEVEN
    this.mueve = function(){

      protagonista.colisionEnemigo(this.x, this.y);



      if(this.contador < this.retraso){
        this.contador++;
      }

      else{
        this.contador = 0;

        //ARRIBA
        if(this.direccion == 0){
		 if (this.y > 0) {
          if(this.compruebaColision(this.x, this.y - 1)==false){
            this.y--;
          }
          else{
            this.direccion = Math.floor(Math.random()*4);
          }
		 }
		 else{
            this.direccion = Math.floor(Math.random()*4);
          }
        }

        //ABAJO
        if(this.direccion == 1){
		 if (this.y < 4) {
          if(this.compruebaColision(this.x, this.y + 1)==false){
            this.y++;
          }
          else{
            this.direccion = Math.floor(Math.random()*4);
          }
		 }
		 else{
            this.direccion = Math.floor(Math.random()*4);
          }
        }

        //IZQUIERDA
        if(this.direccion == 2){
		 if (this.x > 0) {
			 if(this.compruebaColision(this.x - 1, this.y)==false){
            this.x--;
          }
          else{
            this.direccion = Math.floor(Math.random()*4);
          }
		 }
		 else{
            this.direccion = Math.floor(Math.random()*4);
         }
          
        }

        //DERECHA
        if(this.direccion == 3){
			if (this.x < 4) {
				if(this.compruebaColision(this.x + 1, this.y)==false){
				this.x++;
			}
			else{
				this.direccion = Math.floor(Math.random()*4);
			 }
			}
			else{
				this.direccion = Math.floor(Math.random()*4);
			 }
          
        }


      }


    }

}

//CLASE ENEMIGO 2
var malo2 = function(x,y){
    this.x = x;
    this.y = y;

  //DIRECCION DEL ENEMIGO (A DONDE VA IR)

    this.direccion = Math.floor(Math.random()*4);

    this.retraso = 50;
    this.fotograma = 0;

  //CARGAMOS LA IMAGEN DEL tilemap A LOS ENEMIGOS
    this.dibuja2 = function(){
      ctx.drawImage(tileMap,96,32,32,32,this.x*anchoF,this.y*altoF,anchoF,altoF);
    }

   //EL ENEMIGO COMPRUEBA LA COLISION
    this.compruebaColision2 = function(x,y){
        var colisiona = false;

        if(escenario[y][x]==0){
          colisiona = true;
        }
        return colisiona;
    }
	
	this.mueve2 = function(){

      protagonista.colisionEnemigo2(this.x, this.y);



      if(this.contador < this.retraso){
        this.contador++;
      }

      else{
        this.contador = 0;

        //ARRIBA
        if(this.direccion == 0){
		 if (this.y > 0) {
          if(this.compruebaColision2(this.x, this.y - 1)==false){
            this.y--;
          }
          else{
            this.direccion = Math.floor(Math.random()*4);
          }
		 }
		 else{
            this.direccion = Math.floor(Math.random()*4);
          }
        }

        //ABAJO
        if(this.direccion == 1){
		 if (this.y < 4) {
          if(this.compruebaColision2(this.x, this.y + 1)==false){
            this.y++;
          }
          else{
            this.direccion = Math.floor(Math.random()*4);
          }
		 }
		 else{
            this.direccion = Math.floor(Math.random()*4);
          }
        }

        //IZQUIERDA
        if(this.direccion == 2){
		 if (this.x > 0) {
			 if(this.compruebaColision2(this.x - 1, this.y)==false){
            this.x--;
          }
          else{
            this.direccion = Math.floor(Math.random()*4);
          }
		 }
		 else{
            this.direccion = Math.floor(Math.random()*4);
         }
          
        }

        //DERECHA
        if(this.direccion == 3){
			if (this.x < 4) {
				if(this.compruebaColision2(this.x + 1, this.y)==false){
				this.x++;
			}
			else{
				this.direccion = Math.floor(Math.random()*4);
			 }
			}
			else{
				this.direccion = Math.floor(Math.random()*4);
			 }
          
        }


      }


    }
}


//CLASE ENEMIGO 3
var malo3 = function(x,y){
    this.x = x;
    this.y = y;

  //DIRECCION DEL ENEMIGO (A DONDE VA IR)

    this.direccion = Math.floor(Math.random()*4);

    this.retraso = 50;
    this.fotograma = 0;

  //CARGAMOS LA IMAGEN DEL tilemap A LOS ENEMIGOS
    this.dibuja3 = function(){
      ctx.drawImage(tileMap,64,32,32,32,this.x*anchoF,this.y*altoF,anchoF,altoF);
    }

   //EL ENEMIGO COMPRUEBA LA COLISION
    this.compruebaColision3 = function(x,y){
        var colisiona = false;

        if(escenario[y][x]==0){
          colisiona = true;
        }
        return colisiona;
    }
	
	this.mueve3 = function(){

      protagonista.colisionEnemigo3(this.x, this.y);

      if(this.contador < this.retraso){
        this.contador++;
      }

      else{
        this.contador = 0;

        //ARRIBA
        if(this.direccion == 0){
		 if (this.y > 0) {
          if(this.compruebaColision3(this.x, this.y - 1)==false){
            this.y--;
          }
          else{
            this.direccion = Math.floor(Math.random()*4);
          }
		 }
		 else{
            this.direccion = Math.floor(Math.random()*4);
          }
        }

        //ABAJO
        if(this.direccion == 1){
		 if (this.y < 4) {
          if(this.compruebaColision3(this.x, this.y + 1)==false){
            this.y++;
          }
          else{
            this.direccion = Math.floor(Math.random()*4);
          }
		 }
		 else{
            this.direccion = Math.floor(Math.random()*4);
          }
        }

        //IZQUIERDA
        if(this.direccion == 2){
		 if (this.x > 0) {
			 if(this.compruebaColision3(this.x - 1, this.y)==false){
            this.x--;
          }
          else{
            this.direccion = Math.floor(Math.random()*4);
          }
		 }
		 else{
            this.direccion = Math.floor(Math.random()*4);
         }
          
        }

        //DERECHA
        if(this.direccion == 3){
			if (this.x < 4) {
				if(this.compruebaColision3(this.x + 1, this.y)==false){
				this.x++;
			}
			else{
				this.direccion = Math.floor(Math.random()*4);
			 }
			}
			else{
				this.direccion = Math.floor(Math.random()*4);
			 }
          
        }
		
      }


    }
}

//IMUNIDAD

function quitarImunidad() {
	protagonista.imunidad = false;
	permitirQuitar = true;
	//console.log("Se ha quitado la imunidad.");
}

//OBJETO JUGADOR
var jugador = function(){
  this.x = 1;
  this.y = 1;
  this.corazones = 3;
  this.maxcor = 3;
  this.color = '#820c01';
  this.llave = false;
  this.llave_azul = false;
  this.llave_roja = false;
  this.botas = false;
  this.mapa = false;
  this.cor1 = false;
  this.cor2 = false;
  this.cor3 = false;
  this.corp1 = false;
  this.corp2 = false;
  this.corp3 = false;
  this.imunidad = false;

//CARGAMOS LA IMAGEN DEL tilemap AL JUGADOR
  this.dibuja = function(){
    ctx.drawImage(tileMap,32,32,32,32,this.x*anchoF,this.y*altoF,anchoF,altoF);
  }

//COLISION DE LOS ENEMIGOS
  this.colisionEnemigo = function(x,y){
    if(this.x == x && this.y == y && this.imunidad == false){
        protagonista.corazones = protagonista.corazones - 1;

	/*

        if (protagonista.corazones == 1) {
          c1.style.display = "inline";
          c2.style.display = "none";
          c3.style.display = "none";
          c4.style.display = "none";
          c5.style.display = "none";
          c6.style.display = "none";
        }

        if (protagonista.corazones == 2) {
          c1.style.display = "inline";
          c2.style.display = "inline";
          c3.style.display = "none";
          c4.style.display = "none";
          c5.style.display = "none";
          c6.style.display = "none";
        }

        if (protagonista.corazones == 3) {
          c1.style.display = "inline";
          c2.style.display = "inline";
          c3.style.display = "inline";
          c4.style.display = "none";
          c5.style.display = "none";
          c6.style.display = "none";
        }

        if (protagonista.corazones == 4) {
          c1.style.display = "inline";
          c2.style.display = "inline";
          c3.style.display = "inline";
          c4.style.display = "inline";
          c5.style.display = "none";
          c6.style.display = "none";
        }

        if (protagonista.corazones == 5) {
          c1.style.display = "inline";
          c2.style.display = "inline";
          c3.style.display = "inline";
          c4.style.display = "inline";
          c5.style.display = "inline";
          c6.style.display = "none";
        }

        if (protagonista.corazones == 6) {
          c1.style.display = "inline";
          c2.style.display = "inline";
          c3.style.display = "inline";
          c4.style.display = "inline";
          c5.style.display = "inline";
          c6.style.display = "inline";
        }

	*/

	//console.log("Corazones: " + protagonista.corazones);
	//console.log("Se ha puesto la imunidad.");
	this.muerte();
	protagonista.imunidad = true;
    }
	else if(this.x == x && this.y == y && this.imunidad == true && permitirQuitar == true) {
	  setTimeout(quitarImunidad,3000);
	 // console.log("Ha empezado quitar la imunidad.");
	  permitirQuitar = false;
	}

  }
  
  this.colisionEnemigo2 = function(x,y){
    if(this.x == x && this.y == y && this.imunidad == false){
        protagonista.corazones = protagonista.corazones - 2;

	//console.log("Corazones: " + protagonista.corazones);
	//console.log("Se ha puesto la imunidad.");
	this.muerte();
	protagonista.imunidad = true;
    }
	else if(this.x == x && this.y == y && this.imunidad == true && permitirQuitar == true) {
	  setTimeout(quitarImunidad,3000);
	 // console.log("Ha empezado quitar la imunidad.");
	  permitirQuitar = false;
	}

  }
  
  this.colisionEnemigo3 = function(x,y){
    if(this.x == x && this.y == y && this.imunidad == false){
        protagonista.corazones = protagonista.corazones - 3;

	//console.log("Corazones: " + protagonista.corazones);
	//console.log("Se ha puesto la imunidad.");
	this.muerte();
	protagonista.imunidad = true;
    }
	else if(this.x == x && this.y == y && this.imunidad == true && permitirQuitar == true) {
	  setTimeout(quitarImunidad,3000);
	 // console.log("Ha empezado quitar la imunidad.");
	  permitirQuitar = false;
	}

  }

  /*this.cambiocamara = function(x,y){
    var cambio = false;

    if(escenario[y][x]==2){
      cambio = true;
    }

    if(cambio==true){
      console.log('Funciona');
    }

    return(cambio);
  }
 */

 //LOS MARGENES
  this.margenes = function(x,y){
    var colision = false;

    if(escenario[y][x]==0 || (escenario[y][x]==6 && protagonista.llave_azul == false) || (escenario[y][x]==5 && protagonista.llave_roja == false) /*&& ((protagonista.x < 4) && (protagonista.y < 4))*/){
      colision = true;
    }

    return(colision);
  }

  this.arriba = function(){
    if(this.margenes(this.x, this.y-1)==false){
      this.y--;
      this.logicaObjetos();
    }
  }

  this.arriba2 = function(){
    if(this.margenes(this.x, this.y)==false){
      this.y--;
      this.logicaObjetos();
    }
  }


  this.abajo = function(){
    if(this.margenes(this.x, this.y+1)==false){
      this.y++;
      this.logicaObjetos();
    }
  }

  this.izquierda = function(){
    if(this.margenes(this.x-1, this.y)==false){
      this.x--;
      this.logicaObjetos();
    }
  }

  this.izquierda2 = function(){
    if(this.margenes(this.x, this.y)==false){
      this.x--;
      this.logicaObjetos();
    }
  }

  this.derecha = function(){
    if(this.margenes(this.x+1, this.y)==false){
      this.x++;
      this.logicaObjetos();
    }
  }
  
  //ABRIR EL mapa
  
  var cmapa = document.getElementById("imagenmapa");
  var con = 0;
  
  this.abrirmapa = function() {
	 
	if (this.mapa == true) {
		if (con == 0) {
		  cmapa.style.display = "inline";
		  con++;
	  }
	  else if (con == 1) {
		  cmapa.style.display = "none";
		  con = 0;
	  }
	}
  }
  
  //LOS PUZZLES
  
  var puzzle1r = false;
  var puzzle2r = false;
  var puzzle3r = false;
  var puzzle4r = false;
  var puzzle5r = false;
  var puzzle6r = false;
  
  
  puzzleFacil = function() {  
	  if (NumCamara == 5 && puzzle1r == false) {
		  //console.log("Puzzle Facil 1");
		  var res = prompt("Cual fue la primera version de Mazberinto que ha sido publicada en la web de Mr Rainbow Hat Games?");
		  
		  if (res == "1.9") {
			  alert("Respuesta Correcta. Puedes pasar.");
			  escenario[protagonista.y][protagonista.x]=2;
			  puzzle1r = true;
		  }
		  else {
			 alert("Respuesta Incorrecta. Has perdido un corazon."); 
			 protagonista.y = protagonista.y - 1;
			 protagonista.corazones = protagonista.corazones - 1;
			 protagonista.muerte();		 
		  }
	  }
	  
	  if (NumCamara == 13 && puzzle2r == false) {
		  //console.log("Puzzle Facil 2");
		  var res2 = prompt("Cuantos fundadores tiene Mr Rainbow Hat Games");
		  
		  if (res2 == "4") {
			  alert("Respuesta Correcta. Puedes pasar.");
			  escenario[protagonista.y][protagonista.x]=2;
			  puzzle2r = true;
		  }
		  else {
			 alert("Respuesta Incorrecta. Has perdido un corazon."); 
			 protagonista.x = protagonista.x - 1;
			 protagonista.corazones = protagonista.corazones - 1;
			 protagonista.muerte();		 
		  }
	  }
	  
	  if (NumCamara == 18 && puzzle3r == false && (puzzle6r == false)) {
		  //console.log("Puzzle Facil 3");
		  var res3 = prompt("Cuantos minijuegos del modo extremo hay en total?");
		  
		  if (res3 == "15") {
			  alert("Respuesta Correcta. Puedes pasar.");
			  escenario[protagonista.y][protagonista.x]=2;
			  puzzle3r = true;
		  }
		  else {
			 alert("Respuesta Incorrecta. Has perdido un corazon."); 
			 protagonista.y = protagonista.y - 1;
			 protagonista.corazones = protagonista.corazones - 1;
			 protagonista.muerte();		 
		  }
	  } 
	  else if (NumCamara == 18 && puzzle3r == false && (puzzle6r == true)) {
		  //console.log("Puzzle Facil 3");
		  var res3 = prompt("Cuantos minijuegos del modo extremo hay en total?");
		  
		  if (res3 == "15") {
			  alert("Respuesta Correcta. Puedes pasar.");
			  escenario[protagonista.y][protagonista.x]=2;
			  puzzle3r = true;
		  }
		  else {
			 alert("Respuesta Incorrecta. Has perdido un corazon."); 
			 protagonista.y = protagonista.y + 1;
			 protagonista.corazones = protagonista.corazones - 1;
			 protagonista.muerte();		 
		  }
	  } 
  }
  
  puzzleDificil = function() { 
	  if (NumCamara == 8 && puzzle4r == false && (protagonista.llave_azul == false)) {
		  //console.log("Puzzle Dificil 1");
		  var res4 = prompt("Cuantos botones tienes que pulsar en el minijuego troll15?");
		  
		  if (res4 == "4") {
			  alert("Respuesta Correcta. Puedes pasar.");
			  escenario[protagonista.y][protagonista.x]=2;
			  puzzle4r = true;
		  }
		  else {
			 alert("Respuesta Incorrecta. Has perdido tres corazones."); 
			 protagonista.y = protagonista.y - 1;
			 protagonista.corazones = protagonista.corazones - 3;
			 protagonista.muerte();		 
		  }
	  }
	  else if (NumCamara == 8 && puzzle4r == false && (protagonista.llave_azul == true)) {
		  //console.log("Puzzle Dificil 1");
		  var res4 = prompt("Cuantos botones tienes que pulsar en el minijuego troll15?");
		  
		  if (res4 == "4") {
			  alert("Respuesta Correcta. Puedes pasar.");
			  escenario[protagonista.y][protagonista.x]=2;
			  puzzle4r = true;
		  }
		  else {
			 alert("Respuesta Incorrecta. Has perdido tres corazones."); 
			protagonista.y = protagonista.y + 1;
			 protagonista.corazones = protagonista.corazones - 3;
			 protagonista.muerte();		 
		  }
	  }
	  
	  if (NumCamara == 13 && puzzle5r == false && (protagonista.llave_roja == false) && (protagonista.llave == false)) {
		  //console.log("Puzzle Dificil 2");
		  var res5 = prompt("Cuantas preguntas tienes que responder en troll10?");
		  
		  if (res5 == "10") {
			  alert("Respuesta Correcta. Puedes pasar.");
			  escenario[protagonista.y][protagonista.x]=2;
			  puzzle5r = true;
		  }
		  else {
			 alert("Respuesta Incorrecta. Has perdido tres corazones."); 
			 protagonista.x = protagonista.x - 1;
			 protagonista.corazones = protagonista.corazones - 3;
			 protagonista.muerte();		 
		  }
	  }
	  else if (NumCamara == 13 && puzzle5r == false && (protagonista.llave_roja == true) && (protagonista.llave == false)) {
		  //console.log("Puzzle Dificil 2");
		  var res5 = prompt("Cuantas preguntas tienes que responder en troll10?");
		  
		  if (res5 == "10") {
			  alert("Respuesta Correcta. Puedes pasar.");
			  escenario[protagonista.y][protagonista.x]=2;
			  puzzle5r = true;
		  }
		  else {
			 alert("Respuesta Incorrecta. Has perdido tres corazones."); 
			 protagonista.x = protagonista.x - 1;
			 protagonista.corazones = protagonista.corazones - 3;
			 protagonista.muerte();		 
		  }
	  }
	  else if (NumCamara == 13 && puzzle5r == false && (protagonista.llave_roja == true) && (protagonista.llave == true)) {
		  //console.log("Puzzle Dificil 2");
		  var res5 = prompt("Cuantas preguntas tienes que responder en troll10?");
		  
		  if (res5 == "10") {
			  alert("Respuesta Correcta. Puedes pasar.");
			  escenario[protagonista.y][protagonista.x]=2;
			  puzzle5r = true;
		  }
		  else {
			 alert("Respuesta Incorrecta. Has perdido tres corazones."); 
			 protagonista.x = protagonista.x + 1;
			 protagonista.corazones = protagonista.corazones - 3;
			 protagonista.muerte();		 
		  }
	  }
	  
	  if (NumCamara == 18 && puzzle6r == false && (puzzle3r == false)) {
		  //console.log("Puzzle Dificil 3");
		  var res6 = prompt("Que código he puesto en el archivo LEEME?");
		  
		  if (res6 == "op9XD") {
			  alert("Respuesta Correcta. Puedes pasar.");
			  escenario[protagonista.y][protagonista.x]=2;
			  puzzle6r = true;
		  }
		  else {
			 alert("Respuesta Incorrecta. Has perdido tres corazones."); 
			 protagonista.y = protagonista.y - 1;
			 protagonista.corazones = protagonista.corazones - 3;
			 protagonista.muerte();		 
		  }
	  }  
	  else if (NumCamara == 18 && puzzle6r == false && (puzzle3r == true)) {
		  //console.log("Puzzle Dificil 3");
		  var res6 = prompt("Que código he puesto en el archivo LEEME?");
		  
		  if (res6 == "op9XD") {
			  alert("Respuesta Correcta. Puedes pasar.");
			  escenario[protagonista.y][protagonista.x]=2;
			  puzzle6r = true;
		  }
		  else {
			 alert("Respuesta Incorrecta. Has perdido tres corazones."); 
			 protagonista.y = protagonista.y + 1;
			 protagonista.corazones = protagonista.corazones - 3;
			 protagonista.muerte();		 
		  }
	  } 
  }

  //LA VICTORIA
  this.victoria = function(){
	  
	NumCamara = 2;

	 escenario = [
        [0,0,0,0,0,0],
        [0,2,2,0,0,0],
        [0,0,2,2,2,2],
        [0,0,2,0,0,2],
        [0,0,2,0,0,0],
        [0,2,2,0,0,0]
      ];
	  
	puzzle1r = false;
    puzzle2r = false;
    puzzle3r = false;
    puzzle4r = false;
    puzzle5r = false;
    puzzle6r = false;

    this.x = 1;
    this.y = 1;

    this.llave = false;   //el jugador ya no tiene la llave
    this.llave_azul = false;
    this.llave_roja = false;
    this.corazones = 3;
    this.maxcor = 3;
    protagonista.imunidad = false;
    this.mapa = false;
    this.botas = false;
    this.cor1 = false;
    this.cor2 = false;
    this.cor3 = false;
    this.corp1 = false;
    this.corp2 = false;
    this.corp3 = false;
	con = 0;
	cmapa.style.display = "none";
    c1.style.display = "inline";
    c2.style.display = "inline";
    c3.style.display = "inline";
    c4.style.display = "none";
    c5.style.display = "none";
    c6.style.display = "none";

  for (var u = 0; u < enemigo.length; u++) {
    enemigo.pop();
	enemigo.pop();
  }
  
  for (var w = 0; w  < enemigo2.length; w++) {
    enemigo2.pop();
	enemigo2.pop();
  }
  
  for (var g = 0; g < enemigo3.length; g++) {
    enemigo3.pop();
	enemigo3.pop();
  }
    //escenario[8][3] = 3;  //volvemos a poner la llave en su sitio

  }

 //LA MUERTE
  this.muerte = function() {

  if (protagonista.corazones <= 0) {
     decirPierde();
     setTimeout(quitarImunidad,3000);
     //console.log("Corazones: " + protagonista.corazones);

      this.x = 1;
      this.y = 1;

      NumCamara = 2;

      escenario = [
        [0,0,0,0,0,0],
        [0,2,2,0,0,0],
        [0,0,2,2,2,2],
        [0,0,2,0,0,2],
        [0,0,2,0,0,0],
        [0,2,2,0,0,0]
      ];
	  
  puzzle1r = false;
  puzzle2r = false;
  puzzle3r = false;
  puzzle4r = false;
  puzzle5r = false;
  puzzle6r = false;

  this.llave = false;   //el jugador ya no tiene la llave
  this.llave_azul = false;
  this.llave_roja = false;
  this.corazones = 3;
  this.maxcor = 3;
  protagonista.imunidad = false;
  this.mapa = false;
  this.botas = false;
  this.cor1 = false;
  this.cor2 = false;
  this.cor3 = false;
  this.corp1 = false;
  this.corp2 = false;
  this.corp3 = false;
  con = 0;
  cmapa.style.display = "none";
  c1.style.display = "inline";
  c2.style.display = "inline";
  c3.style.display = "inline";
  c4.style.display = "none";
  c5.style.display = "none";
  c6.style.display = "none";

  for (var u = 0; u < enemigo.length; u++) {
    enemigo.pop();
	enemigo.pop();
  }
  
  for (var w = 0; w  < enemigo2.length; w++) {
    enemigo2.pop();
	enemigo2.pop();
  }
  
  for (var g = 0; g < enemigo3.length; g++) {
    enemigo3.pop();
	enemigo3.pop();
  }

   //escenario[8][3] = 3;  //volvemos a poner la llave en su sitio
}


  }

//ENVIAR LOS MENSAJES DE LA CONSOLA

 var mij = document.getElementById("consola");
 var intro = "Consola: Hola, bienvenido a Mazberinto.";
 var infp = "";
 var infp2 = "";
 var inf1 = "";
 var inf2 = "";
 var inf3 = "";
 var inf4 = "";
 var inf5 = "";
 var suminf = "";
 var es1 = "<br><br>Consola: "
 var es2 = "<br><br>Consola: _"
 var nopasar = "<br><br>Consola: No tienes la llave, no puedes pasar!";
 var obtenerllave = "<br><br>Consola: Has obtenido la llave!";
 var jugadorgana = "<br><br>Consola: Has ganado! Ahora puedes volver a jugar.";
 var jugadorpierde = "<br><br>Consola: Has perdido!";

 bienvenida();

function bienvenida() {
	infp = intro;
	suminf = intro;

	mij.innerHTML = infp;

	infp = intro;
	infp2 = intro;
}

function decirLlave() {

	inf2 = suminf;
	suminf = suminf + obtenerllave;

	if (mij.textContent == infp) {
		infp = inf2 + obtenerllave;
		infp2 = inf2 + obtenerllave;
	}
	else {
		infp = inf2 + obtenerllave;
		infp2 = inf2 + obtenerllave;
	}


}

function decirNoPasar() {

	inf3 = suminf;
	suminf = suminf + nopasar;

	if (mij.textContent == infp) {
		infp = inf3 + nopasar;
		infp2 = inf3 + nopasar;
	}
	else {
		infp = inf3 + nopasar;
		infp2 = inf3 + nopasar;
	}


}

function decirVictoria() {

	inf4 = suminf;
	suminf = suminf + jugadorgana;

	if (mij.textContent == infp) {
		infp = inf4 + jugadorgana;
		infp2 = inf4 + jugadorgana;
	}
	else {
		infp = inf4 + jugadorgana;
		infp2 = inf4 + jugadorgana;
	}
}

function decirPierde() {

	inf5 = suminf;
	suminf = suminf + jugadorpierde;

	if (mij.textContent == infp) {
		infp = inf5 + jugadorpierde;
		infp2 = inf5 + jugadorpierde;
	}
	else {
		infp = inf5 + jugadorpierde;
		infp2 = inf5 + jugadorpierde;
	}
}

//escribirConsola1();
//escribirConsola2();

setInterval(escribirConsola1,1000);
setInterval(escribirConsola2,2000);

function escribirConsola1() {
	mij.innerHTML = infp + es1;
	//console.log("Enemigo:" + enemigo);
	//console.log("Enemigo 2:" + enemigo2);
	//console.log("Enemigo 3:" + enemigo3);
}

function escribirConsola2() {
	mij.innerHTML = infp2 + es2;
	//console.log("Enemigo:" + enemigo);
	//console.log("Enemigo 2:" + enemigo2);
	//console.log("Enemigo 3:" + enemigo3);
}

//LOGICA DE LOS OBJETOS (Llave)

/*

NUMEROS TILES

0 = Muro
1 = Salida
2 = Suelo
3 = Llave Dorada
4 = Lava
5 = Candado Rojo
6 = Candado Azul
7 = Llave Azul
8 = Llave Roja
9 = Botas
10 = Mapa
11 = Puzzle
12 = Puzzle Difícil
13 = Corazon 1
14 = Corazon 2
15 = Corazon 3
16 = Corazon Potenciador 1
17 = Corazon Potenciador 2
18 = Corazon Potenciador 3

*/

  this.logicaObjetos = function(){
    var objeto;

	if (protagonista.y > 0) {
		objeto = escenario[this.y][this.x]
	}

    //OBTIENE llave
    if(objeto == 3){
      this.llave = true;
      escenario[this.y][this.x]=2;
      decirLlave();
    }
	
	if(objeto == 4 && this.botas == false){
	  protagonista.corazones = 0;
      this.muerte();
    }

	if(objeto == 5){
      escenario[this.y][this.x]=2;
    }

	if(objeto == 6){
      escenario[this.y][this.x]=2;
    }

	//OBTIENE llave_azul
    if(objeto == 7){
      this.llave_azul = true;
      escenario[this.y][this.x]=2;
      decirLlave();
    }

	//OBTIENE llave_roja
    if(objeto == 8){
      this.llave_roja = true;
      escenario[this.y][this.x]=2;
      decirLlave();
    }

	//OBTIENE Las Botas
    if(objeto == 9){
      this.botas = true;
      escenario[this.y][this.x]=2;
    }

	//OBTIENE El Mapa
    if(objeto == 10){
      this.mapa = true;
      escenario[this.y][this.x]=2;
    }
	
	//ENTRA EN UN PUZZLE
    if(objeto == 11){
      puzzleFacil();
    }
	
	//ENTRA EN UN PUZZLE DIFICIL
    if(objeto == 12){
      puzzleDificil();
    }

	//OBTIENE Corazon 1
	if(objeto == 13){
	  this.cor1 = true;
      escenario[this.y][this.x]=2;
	  
	  if (protagonista.maxcor > protagonista.corazones) {
		 protagonista.corazones = protagonista.corazones + 1;
	  }
    }

	//OBTIENE Corazon 2
	if(objeto == 14){
	  this.cor2 = true;
      escenario[this.y][this.x]=2;
	  
	  if (protagonista.maxcor > protagonista.corazones) {
		 protagonista.corazones = protagonista.corazones + 1;
	  }
    }

	//OBTIENE Corazon 3
	if(objeto == 15){
	  this.cor3 = true;
	  escenario[this.y][this.x]=2;
	  
	  if (protagonista.maxcor > protagonista.corazones) {
		 protagonista.corazones = protagonista.corazones + 1;
	  }
    }

	//OBTIENE Corazon Potenciador 1
	if(objeto == 16){
	  this.corp1 = true;
      escenario[this.y][this.x]=2;
	  protagonista.maxcor = protagonista.maxcor + 1;
	  protagonista.corazones = protagonista.corazones + 1;
    }

	//OBTIENE Corazon Potenciador 2
	if(objeto == 17){
	  this.corp2 = true;
      escenario[this.y][this.x]=2;
	  protagonista.maxcor = protagonista.maxcor + 1;
	  protagonista.corazones = protagonista.corazones + 1;
    }

	//OBTIENE Corazon Potenciador 3
	if(objeto == 18){
	  this.corp3 = true;
      escenario[this.y][this.x]=2;
	  protagonista.maxcor = protagonista.maxcor + 1;
	  protagonista.corazones = protagonista.corazones + 1;
    }

    //ABRIMOS LA PUERTA
    if(objeto == 1){
      if(this.llave == true) {
        this.victoria();
		decirVictoria();
	  }
      else{
        decirNoPasar();
      }
    }


  }

}

/*function hola() {
console.log("Corazones: " + protagonista.corazones)
}


setInterval(hola,1000);

*/

//FUNCION AL CARGAR LA PÀGINA
function inicializa() {
  canvas = document.getElementById('canvas');
  ctx = canvas.getContext('2d');

  //CARGAMOS LA IMAGEN DEL TILEMAP
  imgTilemap = new Image();
  imgTilemap.src = 'img/tilemap.png';
  tileMap = new Image();
  tileMap.src = 'img/tilemap.png';

  /*

  LAS CAMARAS

  NUMEROS PARENTESIS:
  1º,3º y 5º = Coordenadas x
  2º,4º y 6º = Coordenadas y
  Los dos primeros numeros del parentesis son la area de la camara
  Los dos siguentes numeros del parentesis son en que parte del tablero visual va a dibujar la camara
  Los dos ultimos numeros del parentesis son en que parte del canvas se va ver la camara
  */

  //camara = new camaraObj(10,10,0,0,1,1);
  camara2 = new camaraObj2(5,5,0,0,0,0);
  camara3 = new camaraObj2(5,5,0,5,0,5);
  camara4 = new camaraObj2(5,5,0,10,0,10);
  camara5 = new camaraObj2(5,5,0,15,0,15);
  camara6 = new camaraObj2(5,5,5,0,5,0);
  camara7 = new camaraObj2(5,5,10,0,10,0);
  camara8 = new camaraObj2(5,5,15,0,15,0);
  camara9 = new camaraObj2(5,5,20,0,20,0);
  camara10 = new camaraObj2(5,5,20,5,20,5);
  camara11 = new camaraObj2(5,5,20,10,20,10);
  camara12 = new camaraObj2(5,5,20,15,20,15);
  camara13 = new camaraObj2(5,5,15,15,15,15);
  camara14 = new camaraObj2(5,5,15,10,15,10);
  camara15 = new camaraObj2(5,5,15,5,15,5);
  camara16 = new camaraObj2(5,5,10,5,10,5);
  camara17 = new camaraObj2(5,5,5,5,5,5);
  camara18 = new camaraObj2(5,5,10,10,10,10);
  camara19 = new camaraObj2(5,5,5,10,5,10);
  camara20 = new camaraObj2(5,5,5,15,5,15);
  camara21 = new camaraObj2(5,5,10,15,10,15);

  /*

TABLERO CAMARAS

0,5,10,15,20,25 x
5
10    [2, 6, 7, 8, 9]
15    [3,17,16,15,10]
20    [4,19,18,14,11]
y     [5,20,21,13,12]

  */

  //CREAMOS AL JUGADOR
  protagonista = new jugador();

  //CREAMOS LA antorcha
  imagenAntorcha = new antorcha(0,0);
/*
  //CREAMOS LOS ENEMIGOS
  enemigo.push(new malo(3,3));
  enemigo.push(new malo(5,7));
  enemigo.push(new malo(7,7));
*/
  //LECTURA DEL TECLADO
  document.addEventListener('keydown',function(tecla){
   //var velocidadMovimiento = 4;
   //console.log(tecla.keyCode);
    if(tecla.keyCode == 38){
      if((NumCamara == 2) || (NumCamara == 6) || (NumCamara == 7) || (NumCamara == 8) || (NumCamara == 9)){
        protagonista.arriba();
      }
      if(((NumCamara==3) || (NumCamara==4) || (NumCamara==5) || (NumCamara==17) || (NumCamara==19) || (NumCamara==20) || (NumCamara==16) || (NumCamara==18) || (NumCamara==21) || (NumCamara==15) || (NumCamara==14) || (NumCamara==13) || (NumCamara==10) || (NumCamara==11) || (NumCamara==12)) && (protagonista.y == 0)){
        protagonista.arriba2();
      }
      else if ((NumCamara != 2) && (NumCamara != 6) && (NumCamara != 7) && (NumCamara != 8) && (NumCamara != 9)){
        protagonista.arriba();
      }
      //camara2.arriba();
    }

    if(tecla.keyCode == 40){
      protagonista.abajo();
      //camara2.abajo();
    }

    if(tecla.keyCode == 37){
      if((NumCamara == 2) || (NumCamara == 3) || (NumCamara == 4) || (NumCamara == 5)){
        protagonista.izquierda();
     }
      if(((NumCamara==3) || (NumCamara==4) || (NumCamara==5) || (NumCamara==17) || (NumCamara==19) || (NumCamara==20) || (NumCamara==16) || (NumCamara==18) || (NumCamara==21) || (NumCamara==15) || (NumCamara==14) || (NumCamara==13) || (NumCamara==10) || (NumCamara==11) || (NumCamara==12)) && (protagonista.x == 0)){
        protagonista.izquierda2();
      }
      else if ((NumCamara != 2) && (NumCamara != 3) && (NumCamara != 4) && (NumCamara != 5)){
        protagonista.izquierda();
      }
      //camara2.izquierda();
    }

    if(tecla.keyCode == 39){
      protagonista.derecha();
      //camara2.derecha();
    }
	
	if(tecla.keyCode == 77){
      protagonista.abrirmapa();
    }

  });

  setInterval(function(){
    principal();
  },1000/FPS);
}

//BORRAMOS CANVAS PARA EVITAR ERRORES
function borraCanvas(){
//  canvas.width=1250;
//  canvas.height=1000;
  canvas.width=250;
  canvas.height=250;
}

/*

TABLERO CAMARAS

0,5,10,15,20,25 x
5
10    [2, 6, 7, 8, 9]
15    [3,17,16,15,10]
20    [4,19,18,14,11]
y     [5,20,21,13,12]

*/

var NumCamara = 2;

//COMO HACER push() o pop() de los enemigos

/*

	enemigo.push(new malo(x,y));
	enemigo2.push(new malo2(x,y));
	enemigo3.push(new malo3(x,y));	

	enemigo.pop();
	enemigo2.pop();
	enemigo3.pop();

*/

//BUCLE PRINCIPAL
function principal(){
  borraCanvas();
  camara2.dibuja();


  //SUBIR de NumCamara

  if(protagonista.y < 0) {
    if(NumCamara==3) {
      escenario = [
        [0,0,0,0,0,0],
        [0,2,2,0,0,0],
        [0,0,2,2,2,2],
        [0,0,2,0,0,2],
        [0,0,2,0,0,0],
        [0,2,2,0,0,0]
      ];

      NumCamara = 2;
	  
	  enemigo.pop();

      protagonista.y = 4;
    }

    else if (NumCamara==4) {
      escenario = [
        [0,0,2,0,0,0],
	[0,0,2,0,0,0],
	[0,2,2,2,0,0],
	[0,2,2,2,0,0],
	[0,2,0,0,0,0],
	[0,2,0,0,0,0]
      ];

      NumCamara = 3;
	  
	  enemigo2.pop();
	  enemigo.push(new malo(2,3));

      protagonista.y = 4;
    }

	else if (NumCamara==5) {
      escenario = [
        [0,2,0,0,0,0],
        [0,2,2,2,2,2],
        [0,2,2,2,2,2],
        [0,2,0,0,0,2],
        [0,2,0,0,0,2],
        [0,2,2,2,0,2]
      ];
	  
	  enemigo2.push(new malo2(2,2));

      NumCamara = 4;

      protagonista.y = 4;
    }

	else if (NumCamara==20) {
      escenario = [
       	[0,0,0,0,0,0],
	[2,2,2,2,0,0],
	[2,2,4,2,0,0],
	[0,2,2,2,0,0],
	[0,2,0,0,0,0],
	[0,2,0,0,0,0],
      ];
	  
	  enemigo.pop();
	  enemigo.pop();
	  enemigo3.push(new malo3(2,3));

      NumCamara = 19;

      protagonista.y = 4;
    }

	else if (NumCamara==16) {
      escenario = [
        [0,0,0,0,0,0],
	[0,0,0,2,2,2],
	[0,2,2,2,0,0],
	[0,2,2,2,0,0],
	[2,2,0,0,0,0],
	[0,2,0,0,0,0],
      ];

      NumCamara = 7;
	  
	  enemigo.pop();
	  enemigo2.pop();
	  enemigo.push(new malo(3,3));

      protagonista.y = 4;
    }

	else if (NumCamara==17) {
      escenario = [
        [0,0,0,0,0,0],
        [0,0,0,0,0,0],
        [2,2,2,2,0,0],
        [0,0,0,2,0,0],
        [0,0,0,2,2,2],
        [0,0,0,2,0,0]
      ];

      NumCamara = 6;

      protagonista.y = 4;
    }

	else if (NumCamara==10) {
      escenario = [
        [0,0,0,0,0],
		[2,2,2,0,0],
		[0,2,2,2,0],
		[0,2,2,2,0],
		[0,0,2,0,0],
		[0,0,2,0,0],
      ];
	  
	  enemigo.pop();
	  enemigo2.push(new malo2(2,2));

      NumCamara = 9;

      protagonista.y = 4;
    }

	else if (NumCamara==11) {
      escenario = [
        [0,0,2,0,0],
        [0,0,2,0,0],
        [0,0,2,2,0],
        [2,2,2,2,0],
        [0,0,2,0,0],
        [0,0,2,0,0],
      ];

      NumCamara = 10;
	  
	  enemigo2.pop();
	  enemigo.push(new malo(3,3));

      protagonista.y = 4;
    }

	else if (NumCamara==12) {
      escenario = [
        [0,0,2,0,0],
	[0,2,2,2,0],
	[0,2,0,2,0],
	[0,2,2,2,0],
	[0,2,2,0,0],
	[0,2,2,0,0],
      ];

      NumCamara = 11;
	  
	  enemigo.pop();
	  enemigo3.pop();
	  enemigo2.push(new malo2(2,2));

      protagonista.y = 4;
    }

	else if (NumCamara==15) {
      if (protagonista.llave_roja == false && protagonista.corp3 == false) {
		  escenario = [
			[0,0,0,0,0,0],
			[2,2,2,2,2,2],
			[0,0,12,0,0,0],
			[0,8,2,18,0,0],
			[0,0,2,0,0,0],
			[0,0,2,0,0,0],
		  ];
	  }
	  else if (protagonista.llave_roja == true && protagonista.corp3 == false) {
		  escenario = [
			[0,0,0,0,0,0],
			[2,2,2,2,2,2],
			[0,0,12,0,0,0],
			[0,2,2,18,0,0],
			[0,0,2,0,0,0],
			[0,0,2,0,0,0],
		  ];
	  }
	  else if (protagonista.llave_roja == false && protagonista.corp3 == false) {
		  escenario = [
			[0,0,0,0,0,0],
			[2,2,2,2,2,2],
			[0,0,12,0,0,0],
			[0,8,2,2,0,0],
			[0,0,2,0,0,0],
			[0,0,2,0,0,0],
		  ];
	  }
	  else {
		  escenario = [
			[0,0,0,0,0,0],
			[2,2,2,2,2,2],
			[0,0,12,0,0,0],
			[0,2,2,2,0,0],
			[0,0,2,0,0,0],
			[0,0,2,0,0,0],
		  ];
	  }

      NumCamara = 8;

      protagonista.y = 4;
    }

	else if (NumCamara==18) {
      escenario = [
        [0,2,0,0,0,0],
		[0,2,2,4,0,0],
		[0,2,2,2,2,2],
		[2,2,2,2,0,0],
		[0,2,0,0,0,0],
		[0,2,0,0,0,0],
      ];

      NumCamara = 16;
	  
	  enemigo2.push(new malo2(3,2));
	  enemigo.push(new malo(2,3));

      protagonista.y = 4;
    }

	else if (NumCamara==21) {
       if (protagonista.cor3 == false) {
		  escenario = [
			[0,2,0,0,0,0],
			[0,2,2,2,0,0],
			[0,11,0,12,0,0],
			[0,4,0,2,0,0],
			[0,15,0,2,0,0],
			[0,4,0,2,0,0],
		  ];
	 }
	 else {
		 escenario = [
			[0,2,0,0,0,0],
			[0,2,2,2,0,0],
			[0,11,0,12,0,0],
			[0,4,0,2,0,0],
			[0,2,0,2,0,0],
			[0,4,0,2,0,0],
		  ];
	 }

      NumCamara = 18;

      protagonista.y = 4;
    }

	else if (NumCamara==13) {
      escenario = [
        [0,0,0,0,0,0],
		[0,2,2,1,0,0],
		[0,2,2,4,0,0],
		[0,2,2,2,0,0],
		[0,0,0,2,0,0],
		[0,0,0,11,0,0],
      ];

      NumCamara = 14;
	  
	  enemigo3.push(new malo3(2,2));

      protagonista.y = 4;
    }

  }

  //BAJAR de NumCamara

  if(protagonista.y > 4) {

    if(NumCamara==2) {
      escenario = [
        [0,0,2,0,0,0],
		[0,0,2,0,0,0],
		[0,2,2,2,0,0],
		[0,2,2,2,0,0],
		[0,2,0,0,0,0],
		[0,2,0,0,0,0]
      ];

      NumCamara = 3;
	  
	  enemigo.push(new malo(2,3));

      protagonista.y = 0;
    }
    else if(NumCamara==3) {
      escenario = [
        [0,2,0,0,0,0],
        [0,2,2,2,2,2],
        [0,2,2,2,2,2],
        [0,2,0,0,0,2],
        [0,2,0,0,0,2],
        [0,2,2,2,0,2]
      ];
	  
	  enemigo.pop();
	  enemigo2.push(new malo2(2,2));

      NumCamara = 4;

      protagonista.y = 0;
    }

	else if(NumCamara==4) {

	  if (protagonista.mapa == false && protagonista.corp2 == false) {
			 escenario = [
				[0,2,0,0,0,0],
				[0,2,2,2,0,0],
				[0,11,0,6,0,0],
				[0,10,0,17,0,0],
				[0,0,0,0,0,0]
			  ];
		}
		else if (protagonista.mapa == true && protagonista.corp2 == false) {
			escenario = [
				[0,2,0,0,0,0],
				[0,2,2,2,0,0],
				[0,11,0,6,0,0],
				[0,2,0,17,0,0],
				[0,0,0,0,0,0]
			  ];
		}
		else if (protagonista.mapa == false && protagonista.corp2 == true) {
			escenario = [
				[0,2,0,0,0,0],
				[0,2,2,2,0,0],
				[0,11,0,6,0,0],
				[0,10,0,2,0,0],
				[0,0,0,0,0,0]
			  ];
		}
		else {
			escenario = [
				[0,2,0,0,0,0],
				[0,2,2,2,0,0],
				[0,11,0,6,0,0],
				[0,2,0,2,0,0],
				[0,0,0,0,0,0]
			  ];
		}

      NumCamara = 5;
	  
	  enemigo2.pop();

      protagonista.y = 0;
    }

	else if(NumCamara==19) {

	  if (protagonista.botas == false) {
		  escenario = [
			[0,2,0,0,0,0],
			[0,2,2,2,0,0],
			[0,2,2,2,0,0],
			[0,2,2,9,0,0],
			[0,0,0,0,0,0],
		  ];
	  }
	  else {
		  escenario = [
			[0,2,0,0,0,0],
			[0,2,2,2,0,0],
			[0,2,2,2,0,0],
			[0,2,2,2,0,0],
			[0,0,0,0,0,0],
		  ];
	  }

      NumCamara = 20;
	  
	  enemigo3.pop();
	  enemigo.push(new malo(2,3));
	  enemigo.push(new malo(3,1));

      protagonista.y = 0;
    }

	else if(NumCamara==7) {
      escenario = [
        [0,2,0,0,0,0],
		[0,2,2,4,0,0],
		[0,2,2,2,2,2],
		[2,2,2,2,0,0],
		[0,2,0,0,0,0],
		[0,2,0,0,0,0],
      ];

      NumCamara = 16;
	  
	  enemigo.pop();
	  enemigo2.push(new malo2(3,2));
	  enemigo.push(new malo(2,3));

      protagonista.y = 0;
    }

	else if(NumCamara==6) {

		if (protagonista.llave_azul == false && protagonista.cor1 == false && protagonista.corp1 == false) {
			 escenario = [
				[0,0,0,2,0,0],
				[0,7,0,13,0,0],
				[0,16,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}
		else if (protagonista.llave_azul == true && protagonista.cor1 == false && protagonista.corp1 == false) {
			escenario = [
				[0,0,0,2,0,0],
				[0,2,0,13,0,0],
				[0,16,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}
		else if (protagonista.llave_azul == false && protagonista.cor1 == true && protagonista.corp1 == false) {
			escenario = [
				[0,0,0,2,0,0],
				[0,7,0,2,0,0],
				[0,16,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}
		else if (protagonista.llave_azul == false && protagonista.cor1 == false && protagonista.corp1 == true) {
			escenario = [
				[0,0,0,2,0,0],
				[0,7,0,13,0,0],
				[0,2,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}
		else if (protagonista.llave_azul == true && protagonista.cor1 == true && protagonista.corp1 == false) {
			escenario = [
				[0,0,0,2,0,0],
				[0,2,0,2,0,0],
				[0,16,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}
		else if (protagonista.llave_azul == true && protagonista.cor1 == false && protagonista.corp1 == true) {
			escenario = [
				[0,0,0,2,0,0],
				[0,2,0,13,0,0],
				[0,2,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}
		else if (protagonista.llave_azul == false && protagonista.cor1 == true && protagonista.corp1 == true) {
			escenario = [
				[0,0,0,2,0,0],
				[0,7,0,2,0,0],
				[0,2,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}
		else {
			escenario = [
				[0,0,0,2,0,0],
				[0,2,0,2,0,0],
				[0,2,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}

      NumCamara = 17;

      protagonista.y = 0;
    }

	else if(NumCamara==9) {
      escenario = [
        [0,0,2,0,0],
        [0,0,2,0,0],
        [0,0,2,2,0],
        [2,2,2,2,0],
        [0,0,2,0,0],
        [0,0,2,0,0],
      ];

      NumCamara = 10;
	  
	  enemigo2.pop();
	  enemigo.push(new malo(3,3));

      protagonista.y = 0;
    }

	else if(NumCamara==10) {
      escenario = [
        [0,0,2,0,0],
		[0,2,2,2,0],
		[0,2,0,2,0],
		[0,2,2,2,0],
		[0,2,2,0,0],
		[0,2,2,0,0],
      ];
	 
	  enemigo.pop();
	  enemigo2.push(new malo2(2,2));

      NumCamara = 11;

      protagonista.y = 0;
    }

	else if(NumCamara==11) {
      escenario = [
        [0,2,2,0,0],
		[0,2,2,2,0],
		[0,2,2,2,0],
		[5,2,2,2,0],
		[0,0,0,0,0],
      ];

      NumCamara = 12;
	  
	  enemigo2.pop();
	  enemigo.push(new malo(3,2));
	  enemigo3.push(new malo3(1,3));

      protagonista.y = 0;
    }

	else if(NumCamara==8) {
     if (protagonista.cor2 == false) {
		  escenario = [
			[0,0,2,0,0,0],
			[0,2,6,0,0,0],
			[2,2,0,0,0,0],
			[0,0,0,14,2,2],
			[0,0,0,0,0,0],
			[0,0,0,0,0,0],
		  ];
	  }
	  else {
		  escenario = [
			[0,0,2,0,0,0],
			[0,2,6,0,0,0],
			[2,2,0,0,0,0],
			[0,0,0,2,2,2],
			[0,0,0,0,0,0],
			[0,0,0,0,0,0],
		  ];
	  }

      NumCamara = 15;

      protagonista.y = 0;
    }

	else if(NumCamara==16) {

	 if (protagonista.cor3 == false) {
		  escenario = [
			[0,2,0,0,0,0],
			[0,2,2,2,0,0],
			[0,11,0,12,0,0],
			[0,4,0,2,0,0],
			[0,15,0,2,0,0],
			[0,4,0,2,0,0],
		  ];
	 }
	 else {
		 escenario = [
			[0,2,0,0,0,0],
			[0,2,2,2,0,0],
			[0,11,0,12,0,0],
			[0,4,0,2,0,0],
			[0,2,0,2,0,0],
			[0,4,0,2,0,0],
		  ];
	 }

	  enemigo.pop();
	  enemigo2.pop();

      NumCamara = 18;

      protagonista.y = 0;
    }

	else if(NumCamara==18) {
     escenario = [
        [0,4,0,2,0,0],
		[0,4,0,2,0,0],
		[0,4,0,2,0,0],
		[0,2,2,2,2,2],
		[0,0,0,0,0,0],
      ];

      NumCamara = 21;

      protagonista.y = 0;
    }

	else if(NumCamara==14) {
		if (protagonista.llave == false) {
			escenario = [
				[0,0,0,2,0,0],
				[0,2,11,2,0,0],
				[0,2,0,0,0,0],
				[2,2,12,3,5,5],
				[0,0,0,0,0,0],
			  ];
		}
		else {
			escenario = [
				[0,0,0,2,0,0],
				[0,2,11,2,0,0],
				[0,2,0,0,0,0],
				[2,2,12,2,5,5],
				[0,0,0,0,0,0],
			  ];
		}
		
	  enemigo3.pop();

      NumCamara = 13;

      protagonista.y = 0;
    }

  }

  //DERECHA de NumCamara

  if(protagonista.x > 4) {
    if(NumCamara==2) {
      escenario = [
        [0,0,0,0,0,0],
        [0,0,0,0,0,0],
        [2,2,2,2,0,0],
        [0,0,0,2,0,0],
        [0,0,0,2,2,2],
        [0,0,0,2,0,0]
      ];

      NumCamara = 6;

      protagonista.x = 0;
    }

	else if(NumCamara==13) {
      escenario = [
        [0,2,2,0,0],
		[0,2,2,2,0],
		[0,2,2,2,0],
		[5,2,2,2,0],
		[0,0,0,0,0],
      ];

      NumCamara = 12;
	  
	  enemigo.push(new malo(3,2));
	  enemigo3.push(new malo3(1,3));

      protagonista.x = 0;
    }

	else if(NumCamara==6) {
      escenario = [
        [0,0,0,0,0,0],
		[0,0,0,2,2,2],
		[0,2,2,2,0,0],
		[0,2,2,2,0,0],
		[2,2,0,0,0,0],
		[0,2,0,0,0,0],
      ];

      NumCamara = 7;
	  
	  enemigo.push(new malo(3,3));

      protagonista.x = 0;
    }

	else if(NumCamara==7) {
     if (protagonista.llave_roja == false && protagonista.corp3 == false) {
		  escenario = [
			[0,0,0,0,0,0],
			[2,2,2,2,2,2],
			[0,0,12,0,0,0],
			[0,8,2,18,0,0],
			[0,0,2,0,0,0],
			[0,0,2,0,0,0],
		  ];
	  }
	  else if (protagonista.llave_roja == true && protagonista.corp3 == false) {
		  escenario = [
			[0,0,0,0,0,0],
			[2,2,2,2,2,2],
			[0,0,12,0,0,0],
			[0,2,2,18,0,0],
			[0,0,2,0,0,0],
			[0,0,2,0,0,0],
		  ];
	  }
	  else if (protagonista.llave_roja == false && protagonista.corp3 == false) {
		  escenario = [
			[0,0,0,0,0,0],
			[2,2,2,2,2,2],
			[0,0,12,0,0,0],
			[0,8,2,2,0,0],
			[0,0,2,0,0,0],
			[0,0,2,0,0,0],
		  ];
	  }
	  else {
		  escenario = [
			[0,0,0,0,0,0],
			[2,2,2,2,2,2],
			[0,0,12,0,0,0],
			[0,2,2,2,0,0],
			[0,0,2,0,0,0],
			[0,0,2,0,0,0],
		  ];
	  }
	  
	  enemigo.pop();

      NumCamara = 8;

      protagonista.x = 0;
    }

	else if(NumCamara==8) {
      escenario = [
        [0,0,0,0,0],
		[2,2,2,0,0],
		[0,2,2,2,0],
		[0,2,2,2,0],
		[0,0,2,0,0],
		[0,0,2,0,0],
      ];

	 enemigo2.push(new malo2(2,2));

      NumCamara = 9;

      protagonista.x = 0;
    }

	else if(NumCamara==4) {
      escenario = [
        [0,0,0,0,0,0],
		[2,2,2,2,0,0],
		[2,2,4,2,0,0],
		[0,2,2,2,0,0],
		[0,2,0,0,0,0],
		[0,2,0,0,0,0],
      ];
	  
	  enemigo3.push(new malo3(2,3));

      NumCamara = 19;
	  
	  enemigo2.pop();

      protagonista.x = 0;
    }

	else if(NumCamara==15) {
      escenario = [
        [0,0,2,0,0],
        [0,0,2,0,0],
        [0,0,2,2,0],
        [2,2,2,2,0],
        [0,0,2,0,0],
        [0,0,2,0,0],
      ];

      NumCamara = 10;
	  
	  enemigo.push(new malo(3,3));

      protagonista.x = 0;
    }

	else if(NumCamara==16) {
      if (protagonista.cor2 == false) {
		  escenario = [
			[0,0,2,0,0,0],
			[0,2,6,0,0,0],
			[2,2,0,0,0,0],
			[0,0,0,14,2,2],
			[0,0,0,0,0,0],
			[0,0,0,0,0,0],
		  ];
	  }
	  else {
		  escenario = [
			[0,0,2,0,0,0],
			[0,2,6,0,0,0],
			[2,2,0,0,0,0],
			[0,0,0,2,2,2],
			[0,0,0,0,0,0],
			[0,0,0,0,0,0],
		  ];
	  }
	  
	  enemigo.pop();
	  enemigo2.pop();

      NumCamara = 15;

      protagonista.x = 0;
    }

	else if(NumCamara==17) {
      escenario = [
        [0,2,0,0,0,0],
		[0,2,2,4,0,0],
		[0,2,2,2,2,2],
		[2,2,2,2,0,0],
		[0,2,0,0,0,0],
		[0,2,0,0,0,0],
      ];

      NumCamara = 16;
	  
	  enemigo.push(new malo(2,3));
	  enemigo2.push(new malo2(3,2));

      protagonista.x = 0;
    }

	else if(NumCamara==21) {
      if (protagonista.llave == false) {
			escenario = [
				[0,0,0,2,0,0],
				[0,2,11,2,0,0],
				[0,2,0,0,0,0],
				[2,2,12,3,5,5],
				[0,0,0,0,0,0],
			  ];
		}
		else {
			escenario = [
				[0,0,0,2,0,0],
				[0,2,11,2,0,0],
				[0,2,0,0,0,0],
				[2,2,12,2,5,5],
				[0,0,0,0,0,0],
			  ];
		}

      NumCamara = 13;

      protagonista.x = 0;
    }

  }

  //IZQUIERDA de NumCamara

  if(protagonista.x < 0) {
    if(NumCamara==6) {
      escenario = [
        [0,0,0,0,0,0],
        [0,2,2,0,0,0],
        [0,0,2,2,2,2],
        [0,0,2,0,0,2],
        [0,0,2,0,0,0],
        [0,2,2,0,0,0]
      ];

      NumCamara = 2;
	  
      protagonista.x = 4;
    }

	if(NumCamara==7) {
      escenario = [
        [0,0,0,0,0,0],
        [0,0,0,0,0,0],
        [2,2,2,2,0,0],
        [0,0,0,2,0,0],
        [0,0,0,2,2,2],
        [0,0,0,2,0,0]
      ];
	  
	  enemigo.pop();

      NumCamara = 6;

      protagonista.x = 4;
    }

	else if(NumCamara==12) {
      if (protagonista.llave == false) {
			escenario = [
				[0,0,0,2,0,0],
				[0,2,11,2,0,0],
				[0,2,0,0,0,0],
				[2,2,12,3,5,5],
				[0,0,0,0,0,0],
			  ];
		}
		else {
			escenario = [
				[0,0,0,2,0,0],
				[0,2,11,2,0,0],
				[0,2,0,0,0,0],
				[2,2,12,2,5,5],
				[0,0,0,0,0,0],
			  ];
		}

	  enemigo.pop();
	  enemigo3.pop();

      NumCamara = 13;

      protagonista.x = 4;
    }

	else if(NumCamara==8) {
      escenario = [
        [0,0,0,0,0,0],
		[0,0,0,2,2,2],
		[0,2,2,2,0,0],
		[0,2,2,2,0,0],
		[2,2,0,0,0,0],
		[0,2,0,0,0,0],
      ];

      NumCamara = 7;
	  
	  enemigo.push(new malo(3,3));

      protagonista.x = 4;
    }

	else if(NumCamara==9) {
      if (protagonista.llave_roja == false && protagonista.corp3 == false) {
		  escenario = [
			[0,0,0,0,0,0],
			[2,2,2,2,2,2],
			[0,0,12,0,0,0],
			[0,8,2,18,0,0],
			[0,0,2,0,0,0],
			[0,0,2,0,0,0],
		  ];
	  }
	  else if (protagonista.llave_roja == true && protagonista.corp3 == false) {
		  escenario = [
			[0,0,0,0,0,0],
			[2,2,2,2,2,2],
			[0,0,12,0,0,0],
			[0,2,2,18,0,0],
			[0,0,2,0,0,0],
			[0,0,2,0,0,0],
		  ];
	  }
	  else if (protagonista.llave_roja == false && protagonista.corp3 == false) {
		  escenario = [
			[0,0,0,0,0,0],
			[2,2,2,2,2,2],
			[0,0,12,0,0,0],
			[0,8,2,2,0,0],
			[0,0,2,0,0,0],
			[0,0,2,0,0,0],
		  ];
	  }
	  else {
		  escenario = [
			[0,0,0,0,0,0],
			[2,2,2,2,2,2],
			[0,0,12,0,0,0],
			[0,2,2,2,0,0],
			[0,0,2,0,0,0],
			[0,0,2,0,0,0],
		  ];
	  }
	  
	  enemigo2.pop();

      NumCamara = 8;

      protagonista.x = 4;
    }

	else if(NumCamara==19) {
      escenario = [
        [0,2,0,0,0,0],
        [0,2,2,2,2,2],
        [0,2,2,2,2,2],
        [0,2,0,0,0,2],
        [0,2,0,0,0,2],
        [0,2,2,2,0,2]
      ];
	  
	  enemigo3.pop();
	  enemigo2.push(new malo2(2,2));

      NumCamara = 4;

      protagonista.x = 4;
    }

	else if(NumCamara==10) {
      if (protagonista.cor2 == false) {
		  escenario = [
			[0,0,2,0,0,0],
			[0,2,6,0,0,0],
			[2,2,0,0,0,0],
			[0,0,0,14,2,2],
			[0,0,0,0,0,0],
			[0,0,0,0,0,0],
		  ];
	  }
	  else {
		  escenario = [
			[0,0,2,0,0,0],
			[0,2,6,0,0,0],
			[2,2,0,0,0,0],
			[0,0,0,2,2,2],
			[0,0,0,0,0,0],
			[0,0,0,0,0,0],
		  ];
	  }

	  enemigo.pop();

      NumCamara = 15;

      protagonista.x = 4;
    }

	else if(NumCamara==15) {
      escenario = [
        [0,2,0,0,0,0],
		[0,2,2,4,0,0],
		[0,2,2,2,2,2],
		[2,2,2,2,0,0],
		[0,2,0,0,0,0],
		[0,2,0,0,0,0],
      ];

      NumCamara = 16;
	  
	  enemigo.push(new malo(2,3));
	  enemigo2.push(new malo2(3,2));

      protagonista.x = 4;
    }

	else if(NumCamara==16) {
      if (protagonista.llave_azul == false && protagonista.cor1 == false && protagonista.corp1 == false) {
			 escenario = [
				[0,0,0,2,0,0],
				[0,7,0,13,0,0],
				[0,16,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}
		else if (protagonista.llave_azul == true && protagonista.cor1 == false && protagonista.corp1 == false) {
			escenario = [
				[0,0,0,2,0,0],
				[0,2,0,13,0,0],
				[0,16,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}
		else if (protagonista.llave_azul == false && protagonista.cor1 == true && protagonista.corp1 == false) {
			escenario = [
				[0,0,0,2,0,0],
				[0,7,0,2,0,0],
				[0,16,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}
		else if (protagonista.llave_azul == false && protagonista.cor1 == false && protagonista.corp1 == true) {
			escenario = [
				[0,0,0,2,0,0],
				[0,7,0,13,0,0],
				[0,2,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}
		else if (protagonista.llave_azul == true && protagonista.cor1 == true && protagonista.corp1 == false) {
			escenario = [
				[0,0,0,2,0,0],
				[0,2,0,2,0,0],
				[0,16,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}
		else if (protagonista.llave_azul == true && protagonista.cor1 == false && protagonista.corp1 == true) {
			escenario = [
				[0,0,0,2,0,0],
				[0,2,0,13,0,0],
				[0,2,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}
		else if (protagonista.llave_azul == false && protagonista.cor1 == true && protagonista.corp1 == true) {
			escenario = [
				[0,0,0,2,0,0],
				[0,7,0,2,0,0],
				[0,2,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}
		else {
			escenario = [
				[0,0,0,2,0,0],
				[0,2,0,2,0,0],
				[0,2,0,0,0,0],
				[0,2,4,4,2,2],
				[0,0,0,0,0,0],
			  ];
		}
		
	  enemigo.pop();
	  enemigo2.pop();

      NumCamara = 17;

      protagonista.x = 4;
    }

	else if(NumCamara==13) {
      escenario = [
        [0,4,0,2,0,0],
		[0,4,0,2,0,0],
		[0,4,0,2,0,0],
		[0,2,2,2,2,2],
		[0,0,0,0,0,0],
      ];

      NumCamara = 21;

      protagonista.x = 4;
    }

  }

  protagonista.dibuja();

  for(c=0; c<enemigo.length; c++){
    enemigo[c].mueve();
    enemigo[c].dibuja();
  }
  
  for(c=0; c<enemigo2.length; c++){
    enemigo2[c].mueve2();
    enemigo2[c].dibuja2();
  }
  
  for(c=0; c<enemigo3.length; c++){
    enemigo3[c].mueve3();
    enemigo3[c].dibuja3();
  }

  //MOSTRAR CORAZONES AL JUGADOR

  var c1 = document.getElementById("c1");
  var c2 = document.getElementById("c2");
  var c3 = document.getElementById("c3");
  var c4 = document.getElementById("c4");
  var c5 = document.getElementById("c5");
  var c6 = document.getElementById("c6");
  
  if (protagonista.corazones == 1) {
          c1.style.display = "inline";
          c2.style.display = "none";
          c3.style.display = "none";
          c4.style.display = "none";
          c5.style.display = "none";
          c6.style.display = "none";
        }

        if (protagonista.corazones == 2) {
          c1.style.display = "inline";
          c2.style.display = "inline";
          c3.style.display = "none";
          c4.style.display = "none";
          c5.style.display = "none";
          c6.style.display = "none";
        }

        if (protagonista.corazones == 3) {
          c1.style.display = "inline";
          c2.style.display = "inline";
          c3.style.display = "inline";
          c4.style.display = "none";
          c5.style.display = "none";
          c6.style.display = "none";
        }

        if (protagonista.corazones == 4) {
          c1.style.display = "inline";
          c2.style.display = "inline";
          c3.style.display = "inline";
          c4.style.display = "inline";
          c5.style.display = "none";
          c6.style.display = "none";
        }

        if (protagonista.corazones == 5) {
          c1.style.display = "inline";
          c2.style.display = "inline";
          c3.style.display = "inline";
          c4.style.display = "inline";
          c5.style.display = "inline";
          c6.style.display = "none";
        }

        if (protagonista.corazones == 6) {
          c1.style.display = "inline";
          c2.style.display = "inline";
          c3.style.display = "inline";
          c4.style.display = "inline";
          c5.style.display = "inline";
          c6.style.display = "inline";
        }

  //DATOS PARA PRUEBAS

/*

var mostrar_numero_camara = document.getElementById("mostrar_numero_camara");
var mostrar_x = document.getElementById("x");
var mostrar_y = document.getElementById("y");
var mij = document.getElementById("consola");

mostrar_numero_camara.innerHTML = "Numero camara: " + NumCamara;
mostrar_x.innerHTML = "X Jugador: " + protagonista.x;
mostrar_y.innerHTML = "Y Jugador: " + protagonista.y;

<div id="mostrar_numero_camara">Numero Camara = </div>
<div id="x">X Jugador = </div>
<div id="y">Y Jugador = </div>
<img id="imagen" src="escenarios.png">
<div id="escenarios_terminados">Escenarios terminados: Todos</div>

  //[
    /*            6            7             8             9
  2 [0,0,0,0,0,   0,0,0,0,0,   0,0,0,0,0,    0,0,0,0,0,    0,0,0,0,0],
    [0,2,2,0,0,   0,0,0,0,0,   0,0,0,2,2,    2,2,2,2,2,    2,2,2,0,0],
    [0,0,2,2,2,   2,2,2,0,0,   0,2,2,2,0,    0,0,12,0,0,   0,2,2,2,0],
    [0,0,2,0,0,   0,0,2,0,0,   0,2,2,2,0,    0,8,2,18,0,   0,2,2,2,0],
    [0,0,2,2,2,   0,0,2,2,2,   2,2,0,0,0,    0,0,2,0,0,    0,0,2,0,0],
                  17           16            15            10
  3 [0,0,2,0,0,   0,0,2,2,0,   0,2,0,0,0,    0,0,6,0,0,    0,0,2,0,0],
    [0,0,2,0,0,   0,7,2,13,0,  0,2,2,4,0,    0,2,2,0,0,    0,0,2,0,0],
    [0,2,2,2,0,   0,16,0,0,0,  0,2,2,2,2,    2,2,0,0,0,    0,0,2,2,0],
    [0,2,2,2,0,   0,2,4,4,2,   2,2,2,2,0,    0,0,0,14,2,   2,2,2,2,0],
    [0,2,0,0,0,   0,0,0,0,0,   0,2,0,0,0,    0,0,0,0,0,    0,0,2,0,0],
                  19           18            14            11
  4 [0,2,0,0,0,   0,0,0,0,0,   0,2,0,0,0,    0,0,0,0,0,    0,0,2,0,0],
    [0,2,2,2,2,   2,2,2,2,0,   0,2,2,2,0,    0,2,2,1,0,    0,2,2,2,0],
    [0,2,2,2,2,   2,2,4,2,0,   0,11,0,12,0,  0,2,2,4,0,    0,2,0,2,0],
    [0,2,0,0,0,   0,2,2,2,0,   0,4,0,2,0,    0,2,2,2,0,    0,2,2,2,0],
    [0,2,0,0,0,   0,2,0,0,0,   0,15,0,2,0,   0,0,0,2,0,    0,2,2,0,0],
                  20           21            13            12
  5 [0,2,0,0,0,   0,2,0,0,0,   0,4,0,2,0,    0,0,0,11,0,   0,2,2,0,0],
    [0,2,2,2,0,   0,2,2,2,0,   0,4,0,2,0,    0,2,2,2,0,    0,2,2,2,0],
    [0,11,0,6,0,  0,2,2,2,0,   0,4,0,2,0,    0,2,0,0,0,    0,2,2,2,0],
    [0,10,0,17,0, 0,2,2,9,0,   0,2,2,2,2,    2,2,12,3,2,   5,2,2,2,0],
    [0,0,0,0,0,   0,0,0,0,0,   0,0,0,0,0,    0,0,0,0,0,    0,0,0,0,0]
  ];

 ESCENARIOS CAMBIADOS: 3, 5, 17, 19, 20, 7, 16, 18, 21, 8, 15, 14, 13, 9, 11, 12

3

[0,0,2,0,0,0],
[0,0,2,0,0,0],
[0,2,2,2,0,0],
[0,2,2,2,0,0],
[0,2,0,0,0,0],
[0,2,0,0,0,0],

5
[0,2,0,0,0,0],
[0,2,2,2,0,0],
[0,11,0,6,0,0],
[0,10,0,17,0,0],
[0,0,0,0,0,0],

17

[0,0,2,2,0,0],
[0,7,2,13,0,0],
[0,14,0,0,0,0],
[0,2,4,4,2,2],
[0,0,0,0,0,0],

19

[0,0,0,0,0,0],
[2,2,2,2,0,0],
[2,2,4,2,0,0],
[0,2,2,2,0,0],
[0,2,0,0,0,0],
[0,2,0,0,0,0],

20

[0,2,0,0,0,0],
[0,2,2,2,0,0],
[0,2,2,2,0,0],
[0,2,2,9,0,0],
[0,0,0,0,0,0],

7

[0,0,0,0,0,0],
[0,0,0,2,2,0],
[0,2,2,2,0,0],
[0,2,2,2,0,0],
[2,2,0,0,0,0],
[0,2,0,0,0,0],

16

[0,2,0,0,0,0],
[0,2,2,4,0,0],
[0,2,2,2,2,2],
[2,2,2,2,0,0],
[0,2,0,0,0,0],
[0,2,0,0,0,0],

18

[0,2,0,0,0,0],
[0,2,2,2,0,0],
[0,11,0,12,0,0],
[0,4,0,2,0,0],
[0,15,0,2,0,0],
[0,4,0,2,0,0],

21

[0,4,0,2,0,0],
[0,4,0,2,0,0],
[0,4,0,2,0,0],
[0,2,2,2,2,2],
[0,0,0,0,0,0],

8

[0,0,0,0,0,0],
[2,2,12,2,2,2],
[0,0,2,0,0,0],
[0,8,2,18,0,0],
[0,0,2,0,0,0],
[0,0,6,0,0,0],

15

[0,0,6,0,0,0],
[0,2,2,0,0,0],
[2,2,0,0,0,0],
[0,0,0,14,2,2],
[0,0,0,0,0,0],
[0,0,0,0,0,0],

14

[0,0,0,0,0,0],
[0,2,2,1,0,0],
[0,2,2,4,0,0],
[0,2,2,2,0,0],
[0,0,0,2,0,0],
[0,0,0,11,0,0],

13

[0,0,0,11,0,0],
[0,2,2,2,0,0],
[0,2,0,0,0,0],
[2,2,12,3,2,5],
[0,0,0,0,0,0],

9

[0,0,0,0,0],
[2,2,2,0,0],
[0,2,2,2,0],
[0,2,2,2,0],
[0,0,2,0,0],
[0,0,2,0,0],

11

[0,0,2,0,0],
[0,2,2,2,0],
[0,2,0,2,0],
[0,2,2,2,0],
[0,2,2,0,0],

12

[0,2,2,0,0],
[0,2,2,2,0],
[0,2,2,2,0],
[5,2,2,2,0],
[0,0,0,0,0],

/*

NUMEROS TILES

0 = Muro
1 = Salida
2 = Suelo
3 = Llave Dorada
4 = Lava
5 = Candado Rojo
6 = Candado Azul
7 = Llave Azul
8 = Llave Roja
9 = Botas
10 = Mapa
11 = Puzzle
12 = Puzzle Difícil
13 = Corazon 1
14 = Corazon 2
15 = Corazon 3
16 = Corazon Potenciador 1
17 = Corazon Potenciador 2
18 = Corazon Potenciador 3

*/

//NOTA: Los escenarios del bucle son distintos a los de aquí. Estos son los originales.



  //dibujaEscenario();
  //camara.dibuja();
/*  camara3.dibuja();
  camara4.dibuja();
  camara5.dibuja();
  camara6.dibuja();
  camara7.dibuja();
  camara8.dibuja();
  camara9.dibuja();
  camara10.dibuja();
  camara11.dibuja();
  camara12.dibuja();
  camara13.dibuja();
  camara14.dibuja();
  camara15.dibuja();
  camara16.dibuja();
  camara17.dibuja();
  camara18.dibuja();
  camara19.dibuja();
  camara20.dibuja();
  camara21.dibuja();
  */
  //imagenAntorcha.dibuja();

}
